/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.pocket;

import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class PocketComputerData {
    private @Nullable NetworkedTerminal terminal;
    private ComputerState state;
    private int lightColour;

    PocketComputerData(ComputerState state, int lightColour, @Nullable TerminalState terminalData) {
        this.state = state;
        this.lightColour = lightColour;
        if (terminalData != null) {
            this.terminal = terminalData.create();
        }
    }

    public int getLightState() {
        return this.state != ComputerState.OFF ? this.lightColour : -1;
    }

    public @Nullable NetworkedTerminal getTerminal() {
        return this.terminal;
    }

    public ComputerState getState() {
        return this.state;
    }

    void setState(ComputerState state, int lightColour, @Nullable TerminalState terminalData) {
        this.state = state;
        this.lightColour = lightColour;
        if (terminalData != null) {
            if (this.terminal == null) {
                this.terminal = terminalData.create();
            } else {
                terminalData.apply(this.terminal);
            }
        }
    }
}

